/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.entity;

import dev.xkmc.curseofpandora.content.sets.abyss.AbyssalCrown;
import dev.xkmc.curseofpandora.content.sets.abyss.AbyssalWill;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.registrate.CoPEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AbyssalFangs
extends Entity
implements TraceableEntity {
    public static final int ATTACK_DURATION = 20;
    public static final int LIFE_OFFSET = 2;
    public static final int ATTACK_TRIGGER_TICKS = 14;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public static void circle(LivingEntity owner) {
        double d0 = owner.m_20186_() - 5.0;
        double d1 = owner.m_20186_() + 5.0;
        float f = (owner.m_146908_() + 90.0f) * ((float)Math.PI / 180);
        for (int i = 0; i < 5; ++i) {
            float f1 = f + (float)i * (float)Math.PI * 0.4f;
            AbyssalFangs.createSpellEntity(owner, owner.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, owner.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
        }
        for (int k = 0; k < 8; ++k) {
            float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
            AbyssalFangs.createSpellEntity(owner, owner.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, owner.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
        }
    }

    public static void straight(LivingEntity owner) {
        double d0 = owner.m_20186_() - 5.0;
        double d1 = owner.m_20186_() + 5.0;
        float f = (owner.m_146908_() + 90.0f) * ((float)Math.PI / 180);
        for (int i = 0; i < 16; ++i) {
            double d2 = 1.25 * (double)(i + 1);
            AbyssalFangs.createSpellEntity(owner, owner.m_20185_() + (double)Mth.m_14089_((float)f) * d2, owner.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, i);
        }
    }

    private static void createSpellEntity(LivingEntity owner, double x, double z, double y0, double y1, float rot, int delay) {
        Level level = owner.m_9236_();
        BlockPos origin = BlockPos.m_274561_((double)x, (double)y1, (double)z);
        boolean flag = false;
        double height = 0.0;
        do {
            BlockState up;
            VoxelShape voxelshape;
            BlockPos below;
            BlockState down;
            if (!(down = level.m_8055_(below = origin.m_7495_())).m_60783_((BlockGetter)level, below, Direction.UP)) continue;
            if (!level.m_46859_(origin) && !(voxelshape = (up = level.m_8055_(origin)).m_60812_((BlockGetter)level, origin)).m_83281_()) {
                height = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((origin = origin.m_7495_()).m_123342_() >= Mth.m_14107_((double)y0) - 1);
        if (flag) {
            level.m_7967_((Entity)new AbyssalFangs(level, x, (double)origin.m_123342_() + height, z, rot, delay, owner));
        }
    }

    public AbyssalFangs(EntityType<? extends AbyssalFangs> type, Level level) {
        super(type, level);
    }

    public AbyssalFangs(Level level, double x, double y, double z, float yrot, int delay, LivingEntity owner) {
        this((EntityType<? extends AbyssalFangs>)((EntityType)CoPEntities.ABYSSAL_FANGS.get()), level);
        this.warmupDelayTicks = delay;
        this.setOwner(owner);
        this.m_146922_(yrot * 57.295776f);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag tag) {
        this.warmupDelayTicks = tag.m_128451_("Warmup");
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 20) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1.0, 0.0, 0.0);
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                double r = 0.7;
                double height = 3.0;
                AABB aabb = this.m_20191_().m_82377_(r, height, r);
                for (LivingEntity target : this.m_9236_().m_45976_(LivingEntity.class, aabb)) {
                    this.dealDamageTo(target);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        if (target.m_6084_() && !target.m_20147_() && target != owner) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (owner.m_7307_((Entity)target)) {
                    return;
                }
                int step = AbyssalWill.getStep(player);
                ResourceKey<DamageType> type = CoPDamageTypeGen.ABYSSAL_FANG;
                if ((double)step * AbyssalCrown.getChance() > player.m_217043_().m_188500_()) {
                    type = CoPDamageTypeGen.ECHO_ABYSSAL_FANG;
                }
                target.m_6469_(new DamageSource(CoPDamageTypeGen.forKey(this.m_9236_(), type), (Entity)this, (Entity)owner), (float)player.m_21133_(Attributes.f_22281_));
            } else {
                target.m_6469_(this.m_269291_().m_269425_(), 6.0f);
            }
        }
    }

    public void m_7822_(byte event) {
        super.m_7822_(event);
        if (event == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float pTick) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pTick) / 20.0f;
    }
}

